<?php
/***************************************************************************
 *
 * 	----------------------------------------------------------------------
 * 						DO NOT EDIT THIS FILE
 *	----------------------------------------------------------------------
 * 
 *  				     Copyright (C) Themify
 * 
 *	----------------------------------------------------------------------
 *
 ***************************************************************************/

defined( 'ABSPATH' ) || exit;

// Initialize actions
$themify_ajax_actions = array(
	'plupload',
	'get_404_pages',
	'remove_video',
	'save',
	'reset_settings',
	'pull',
	'add_link_field',
	'media_lib_browse',
	'import_sample_content',
	'erase_sample_content',
	'import_sample_actions',
	'clear_all_webp',
	'clear_all_menu',
	'clear_all_concate',
	'clear_all_html',
        'search_autocomplete',
        'twitter_flush',
        'ajax_load_more'
);
foreach($themify_ajax_actions as $action){
	add_action('wp_ajax_themify_' . $action, 'themify_' . $action);
}

//Show 404 page in autocomplete
function themify_get_404_pages(){
    if(!empty($_POST['term'])){
        $args = array(
                'sort_order' => 'asc',
                'sort_column' => 'post_title',
                'post_type' => 'page',
                's'=>  sanitize_text_field($_POST['term']),
		'no_found_rows'=>true,
		'ignore_sticky_posts'=>true,
		'cache_results'=>false,
		'update_post_term_cache'=>false,
		'update_post_meta_cache'=>false,
                'post_status' => 'publish',
                'posts_per_page' => 15
        );
        add_filter( 'posts_search', 'themify_posts_where', 10, 2 );
        $terms = new WP_Query($args);
        $items = array();
        if($terms->have_posts()){
            while ($terms->have_posts()){
                $terms->the_post();
                $items[] = array('value'=>  get_the_ID(),'label'=>  get_the_title());
            }
        }
        echo wp_json_encode($items);
    }
    wp_die();
}

//Search only by post title
function themify_posts_where($search,$wp_query ){       
    if ( ! empty( $search ) && ! empty( $wp_query->query_vars['search_terms'] ) ) {
        global $wpdb;

        $q = $wp_query->query_vars;
        $n = ! empty( $q['exact'] ) ? '' : '%';

        $search = array();
        $search[] = $wpdb->prepare( "$wpdb->posts.post_title LIKE %s", $wpdb->esc_like( implode(' ',$q['search_terms']) ) . $n );

        if ( ! is_user_logged_in() )
            $search[] = "$wpdb->posts.post_password = ''";

        $search = ' AND ' . implode( ' AND ', $search );
    }
    return $search;
}
/**
 * AJAX - Plupload execution routines
 * @since 1.2.2
 * @package themify
 */
function themify_plupload() {
    $imgid = $_POST['imgid'];
    ! empty( $_POST[ '_ajax_nonce' ] ) && check_ajax_referer($imgid . 'themify-plupload');
	/** Decide whether to send this image to Media. @var String */
	$add_to_media_library = isset( $_POST['tomedia'] ) ? $_POST['tomedia'] : false;
	/** If post ID is set, uploaded image will be attached to it. @var String */
	$postid = isset( $_POST['topost'] )? $_POST['topost'] : '';
 
    /** Handle file upload storing file|url|type. @var Array */
    $file = wp_handle_upload($_FILES[$imgid . 'async-upload'], array('test_form' => true, 'action' => 'themify_plupload'));
	
	// if $file returns error, return it and exit the function
	if ( isset( $file['error'] ) && ! empty( $file['error'] ) ) {
		echo json_encode($file);
		exit;
	}

	//let's see if it's an image, a zip file or something else
	$ext = explode('/', $file['type']);
	
	// Import routines
	if( 'zip' === $ext[1] || 'rar' === $ext[1] || 'plain' === $ext[1] ){
		
		$url = wp_nonce_url('admin.php?page=themify');

		if (false === ($creds = request_filesystem_credentials($url) ) ) {
			return true;
		}
		if ( ! WP_Filesystem($creds) ) {
			request_filesystem_credentials($url, '', true);
			return true;
		}
		
		global $wp_filesystem;
		
		if ( 'zip' === $ext[1] || 'rar' === $ext[1] ) {
			$upload_dir = themify_get_cache_dir();
			unzip_file( $file['file'], $upload_dir['path'] );
			if( $wp_filesystem->exists( $upload_dir['path'] . 'data_export.txt' ) ){
				$data = $wp_filesystem->get_contents( $upload_dir['path'] . 'data_export.txt' );
				themify_set_data( unserialize( $data ) );
				$wp_filesystem->delete( $upload_dir['path'] . 'data_export.txt' );
				$wp_filesystem->delete($file['file']);
			} else {
				echo json_encode( array( 'error' => __( 'Data could not be loaded', 'themify' ) ) );
				die;
			}
		} else {
			if( $wp_filesystem->exists( $file['file'] ) ){
				$data = $wp_filesystem->get_contents( $file['file'] );
				themify_set_data( unserialize( $data ) );
				$wp_filesystem->delete($file['file']);
			} else {
				echo json_encode( array( 'error' => __( 'Data could not be loaded', 'themify' ) ) );
				die;
			}
		}
		
	} else {
		//Image Upload routines
		if( 'tomedia' === $add_to_media_library ){
			
			// Insert into Media Library
			// Set up options array to add this file as an attachment
	        $attachment = array(
	            'post_mime_type' => sanitize_mime_type($file['type']),
	            'post_title' => str_replace('-', ' ', sanitize_file_name(pathinfo($file['file'], PATHINFO_FILENAME))),
	            'post_status' => 'inherit'
	        );
			
			if( $postid ){
				$attach_id = wp_insert_attachment( $attachment, $file['file'], $postid );
			} else {
				$attach_id = wp_insert_attachment( $attachment, $file['file'] );
			}
			$file['id'] = $attach_id;

			// Common attachment procedures
			require_once(ABSPATH . 'wp-admin/includes/image.php');
		    $attach_data = wp_generate_attachment_metadata( $attach_id, $file['file'] );
		    wp_update_attachment_metadata($attach_id, $attach_data);
			
			if( $postid ) {
				
				$full = wp_get_attachment_image_src( $attach_id, 'full' );

				update_post_meta($postid, $_POST['fields'], $full[0]);
				update_post_meta($postid, '_'.$_POST['fields'] . '_attach_id', $attach_id);				
			}

			$thumb = wp_get_attachment_image_src( $attach_id, 'thumbnail' );
			
			//Return URL for the image field in meta box
			$file['thumb'] = $thumb[0];
		}
	}
	$file['type'] = $ext[1];
	// send the uploaded file url in response
	echo json_encode($file);
    exit;
}

/**
 * AJAX - Remove image assigned in Themify custom panel. Clears post_image and _thumbnail_id field.
 * @since 1.7.4
 * @package themify
 */
function themify_remove_video() {
	check_ajax_referer( 'themify-custom-panel', 'nonce' );
	if ( isset( $_POST['postid'], $_POST['customfield'] ) ) {
		update_post_meta( $_POST['postid'], $_POST['customfield'], '' );
	} else {
		_e( 'Missing vars: post ID and custom field.', 'themify' );
	}
	die();
}

/**
 * AJAX - Save user settings
 * @since 1.1.3
 * @package themify
 */
function themify_save(){
	$previous_data = themify_get_data();

	check_ajax_referer( 'ajax-nonce', 'nonce' );
	$temp = apply_filters( 'themify_save_data', themify_normalize_save_data( $_POST['data'] ), $previous_data );
	unset($temp['tmp_cache_network'],$temp['tmp_cache_concte_network'],$temp['tmp_regenerate_all_css']);
	themify_set_data( $temp );
	_e('Your settings were saved', 'themify');

	if (
		Themify_Enqueue_Assets::$mobileMenuActive !== intval( $temp['setting-mobile_menu_trigger_point'] )
		|| ( isset( $previous_data['skin'] ) && $previous_data['skin'] !== $temp['skin'])
        || ( isset( $previous_data['setting-header_design'] ) && $previous_data['setting-header_design'] !== $temp['setting-header_design'])
        || ( isset( $previous_data['setting-exclude_menu_navigation'] ) && $previous_data['setting-exclude_menu_navigation'] !== $temp['setting-exclude_menu_navigation'])
	) {
		Themify_Enqueue_Assets::clearConcateCss();
	}

	/* clear webP image cache when changing image quality */
	if ( isset( $previous_data['setting-webp-quality'] ) && (int) $previous_data['setting-webp-quality'] !== (int) $temp['setting-webp-quality'] ) {
		Themify_Enqueue_Assets::removeWebp();
	}

	if ( class_exists( 'Themify_Builder_Stylesheet' ) ) {
		$breakpoints=themify_get_breakpoints('all',true);
		foreach ( $breakpoints as $bp=>$v ) {
			if ( isset( $previous_data["setting-customizer_responsive_design_{$bp}"] ) && $previous_data["setting-customizer_responsive_design_{$bp}"] !== $temp["setting-customizer_responsive_design_{$bp}"] ) {
				Themify_Builder_Stylesheet::regenerate_css_files();
				break;
			}
		}
	}
	unset($previous_data);
	if(themify_get_server()==='nginx'){
		if(empty($temp['setting-webp'])){
			Themify_Enqueue_Assets::removeWebp();
		}
	}
	else{
		Themify_Enqueue_Assets::rewrite_htaccess((!empty($temp['setting-dev-mode'])?true:empty($temp['setting-cache_gzip'])),empty($temp['setting-webp']));
	}
	TFCache::remove_cache();
	if(empty($temp['setting-dev-mode'])){
		TFCache::create_config($temp);
	}
	else{
		TFCache::disable_cache();
	}
    TFCache::clear_3rd_plugins_cache();
	wp_die();
}

function themify_normalize_save_data($data){
    $data = explode('&', $data);
    $temp = array();
    foreach($data as $a){
	    $v = explode('=', $a);
	    $temp[$v[0]] = urldecode( str_replace('+',' ',preg_replace_callback('/%([0-9a-f]{2})/i', 'themify_save_replace_cb', urlencode($v[1]))) );
    }
    return $temp;
}

/**
 * Replace callback for preg_replace_callback used in themify_save().
 * 
 * @since 2.2.5
 * 
 * @param array $matches 0 complete match 1 first match enclosed in (...)
 * 
 * @return string One character specified by ascii.
 */
function themify_save_replace_cb( $matches ) {
	// "chr(hexdec('\\1'))"
	return chr( hexdec( $matches[1] ) );
}

/**
 * AJAX - Reset Settings
 * @since 1.1.3
 * @package themify
 */
function themify_reset_settings(){
	check_ajax_referer( 'ajax-nonce', 'nonce' );
	$temp_data = themify_normalize_save_data($_POST['data']);
	$temp = array();
	foreach($temp_data as $key => $val){
		// Don't reset if it's not a setting or the # of social links or a social link or the Hook Contents
		if(strpos($key, 'setting') === false || strpos($key, 'hooks') || strpos($key, 'link_field_ids') || strpos($key, 'themify-link') || strpos($key, 'twitter_settings') || strpos($key, 'custom_css')){
			$temp[$key] = $val;
		}
	}
        $temp['setting-script_minification'] = 'disable';
	print_r(themify_set_data($temp));
	die();
}

/**
 * Export Settings to zip file and prompt to download
 * NOTE: This function is not called through AJAX but it is kept here for consistency. 
 * @since 1.1.3
 * @package themify
 */
function themify_export() {
	if ( isset( $_GET['export'] ) && 'themify' === $_GET['export'] ) {
		check_admin_referer( 'themify_export_nonce' );
		$theme = wp_get_theme();
		$theme_name = $theme->display('Name');

		if ( ! function_exists( 'WP_Filesystem' ) ) {
			require_once ABSPATH . 'wp-admin/includes/file.php';
		}
		WP_Filesystem();
		global $wp_filesystem;

		$upload_dir = themify_get_cache_dir();
		if ( class_exists( 'ZipArchive' ) && $upload_dir ) {
			$datafile = $upload_dir['path'] . 'data_export.txt';
			$wp_filesystem->put_contents( $datafile, serialize( themify_get_data() ) );
                        $dir=get_template_directory();
			$files_to_zip = array(
				$dir . '/custom-modules.php',
				$dir . '/custom-functions.php',
				$dir . '/custom-config.php',
				$dir . '/custom_style.css',
				$datafile
			);
			$file = $upload_dir['path'] . $theme_name . '_themify_export_' . date('Y_m_d') . '.zip';
			$result = themify_create_zip( $files_to_zip, $file, true );
		}
		if(isset($result) && $result){
			if ( ( isset( $file ) ) && ( $wp_filesystem->exists( $file ) ) ) {
				ob_start();
				header('Pragma:public');
				header('Expires:0');
				header('Content-type:application/force-download');
				header('Content-Disposition:attachment; filename="' . basename( $file ) . '"');
				header('Content-Transfer-Encoding:Binary'); 
				header('Content-length:'.filesize($file));
				header('Connection:close');
				ob_clean();
				flush();
				echo $wp_filesystem->get_contents( $file );
				$wp_filesystem->delete( $datafile );
				$wp_filesystem->delete( $file );
				exit();
			} else {
				return false;
			}
		} else {
			if ( ini_get( 'zlib.output_compression' ) ) {
				/**
				 * Turn off output buffer compression for proper zip download.
				 * @since 2.0.2
				 */
				ini_set( 'zlib.output_compression', 'Off' );
			}
			ob_start();
			header('Content-Type: application/force-download');
			header('Pragma: public');
			header('Expires: 0');
			header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
			header('Cache-Control: private',false);
			header('Content-Disposition: attachment; filename="'.$theme_name.'_themify_export_'.date("Y_m_d").'.txt"');
			header('Content-Transfer-Encoding: binary');
			ob_clean();
			flush();
			echo serialize(themify_get_data());
			exit();
		}
	}
	return false;
}
add_action( 'load-toplevel_page_themify', 'themify_export' );

/**
 * Pull data for inspection
 * @since 1.1.3
 * @package themify
 */
function themify_pull(){
	print_r(themify_get_data());
	die();
}

function themify_add_link_field(){
	check_ajax_referer( 'ajax-nonce', 'nonce' );
	
	if( isset($_POST['fid']) ) {
		$hash = $_POST['fid'];
		$type = isset( $_POST['type'] )? $_POST['type'] : 'image-icon';
		echo themify_add_link_template( 'themify-link-'.$hash, array(), true, $type);
		exit();
	}
}

/**
 * Set image from wp library
 * @since 1.2.9
 * @package themify
 */
function themify_media_lib_browse() {
	if ( ! wp_verify_nonce( $_POST['media_lib_nonce'], 'media_lib_nonce' ) ) die(-1);

	$file = array();
	$postid = $_POST['post_id'];
	$attach_id = $_POST['attach_id'];

	$full = wp_get_attachment_image_src( $attach_id, 'full' );
	if( $_POST['featured'] ){
		//Set the featured image for the post
		set_post_thumbnail($postid, $attach_id);
	}
	update_post_meta($postid, $_POST['field_name'], $full[0]);
	update_post_meta($postid, '_'.$_POST['field_name'] . '_attach_id', $attach_id);

	$thumb = wp_get_attachment_image_src( $attach_id, 'thumbnail' );

	//Return URL for the image field in meta box
	$file['thumb'] = $thumb[0];

	echo json_encode($file);

	exit();
}
/**
 * Get the path to import.php file
 *
 * @return string|WP_Error
 */
function themify_get_sample_content_file() {
	// importing demo content for an skin,regular old demo import
	$skin = isset( $_POST['skin'] ) ? '/' . sanitize_text_field( $_POST['skin'] ) : '';
	$sample_file = tf_fetch_remote_file( 'https://themify.me/public-api/samples/' . get_template() . $skin . '/import.zip' );
	if ( is_wp_error( $sample_file ) ) {
		return $sample_file;
	}

	$cache_dir = themify_get_cache_dir();
	$extract_file = $cache_dir['path'] . 'import.php';

	if ( is_file( $extract_file ) ) {
		unlink( $extract_file );
	}
	if ( ! function_exists( 'WP_Filesystem' ) ) {
		require_once ABSPATH . 'wp-admin/includes/file.php';
	}
	WP_Filesystem();
	$result = unzip_file( get_attached_file( $sample_file ), $cache_dir['path'] );
	wp_delete_attachment( $sample_file, true );
	if ( is_wp_error( $result ) ) {
		return $result;
	}

	return is_file( $extract_file ) ? $extract_file : new WP_Error( 'tf_sample_not_found', __( 'Sample file not found', 'themify' ) );
}

/**
 * Imports sample contents to replicate the demo site.
 *
 * @since 1.7.6
 */
function themify_import_sample_content() {

	$file = themify_get_sample_content_file();
	if ( is_wp_error( $file ) ) {
		wp_send_json_error( array(
			'error' => sprintf( __( 'Failed to get the sample file. Error: %s', 'themify' ), $file->get_error_message() ),
		) );
	}

	/* these constants are used in the import.php file */
	define( 'IMPORT_IMAGES', isset( $_POST['import_images'] ) && sanitize_text_field( $_POST['import_images'] ) === 'yes' );

	do_action( 'themify_before_demo_import' );

	include THEMIFY_DIR . '/themify-import-functions.php';

	if ( isset( $_POST['clear_old_imports'] ) && sanitize_text_field( $_POST['clear_old_imports'] ) === 'yes' ) {
		Themify_Import_Helper::erase_demo();
	}

	if (is_file( $file ) ) {
		include_once( $file );
		themify_do_demo_import();
	}
	do_action( 'themify_after_demo_import' );

	wp_send_json_success( array(
		'actions' => Themify_Import_Helper::get_import_actions(),
	) );
}

function themify_import_sample_actions() {
	check_ajax_referer( 'ajax-nonce', 'nonce' );
	$action = sanitize_text_field( $_POST['_action'] );

	switch( $action ) {
		case 'post_thumb' :
			$post_id = (int) $_POST['data']['id'];
			$url = sanitize_text_field( $_POST['data']['thumb'] );

			$fetch = tf_fetch_remote_file( $url, $post_id );
			if ( is_wp_error( $fetch ) ) {
				wp_send_json_error( array( 'error' => $fetch->get_error_message() ) );
			}

			set_post_thumbnail( $post_id, $fetch );
			update_post_meta( $fetch, '_tf_demo', 1 );
			wp_send_json_success();
			break;

		case 'term_thumb' :
			$id = (int) $_POST['data']['id'];
			$url = sanitize_text_field( $_POST['data']['thumb'] );

			$fetch = tf_fetch_remote_file( $url );
			if ( is_wp_error( $fetch ) ) {
				wp_send_json_error( array( 'error' => $fetch->get_error_message() ) );
			}

			update_term_meta( $id, 'thumbnail_id', $fetch );
			update_post_meta( $fetch, '_tf_demo', 1 );
			wp_send_json_success();
			break;

		case 'gallery_field' :
			$post_id = (int) $_POST['data']['id'];
			$fields = $_POST['data']['fields'];

			foreach( $fields as $field_id => $values ) {
				$ids = array();
				foreach ( $values as $url ) {
					$fetch = tf_fetch_remote_file( $url, $post_id );
					if ( ! is_wp_error( $fetch ) ) {
						$ids[] = $fetch;
						update_post_meta( $fetch, '_tf_demo', 1 );
					}
				}

				// if field already exists, try just plopping the new IDs in the existing shortcode
				if ( ( $previous_value = get_post_meta( $post_id, $field_id, true ) ) && preg_match( '/ids=/', $previous_value ) ) {
					$new_value = preg_replace( '/ids=[\'"](.*?)[\'"]/', 'ids="' . implode( ',', $ids ) . '"', $previous_value );
				} else {
					$new_value = '[gallery ids="' . implode( ',', $ids ) . '"]';
				}
				update_post_meta( $post_id, $field_id, $new_value );
			}

			wp_send_json_success();
			break;

		case 'product_gallery' :
			$post_id = (int) $_POST['data']['id'];
			$images = $_POST['data']['images'];

			$ids = array();
			foreach ( $images as $url ) {
				$fetch = tf_fetch_remote_file( $url, $post_id );
				if ( ! is_wp_error( $fetch ) ) {
					$ids[] = $fetch;
					update_post_meta( $fetch, '_tf_demo', 1 );
				}
			}
			update_post_meta( $post_id, '_product_image_gallery', implode( ',', $ids ) );

			wp_send_json_success();
			break;
	}
}


/**
 * Cleans up the sample content installed.
 *
 * @since 1.7.6
 */
function themify_erase_sample_content() {
	include THEMIFY_DIR . '/themify-import-functions.php';
	Themify_Import_Helper::erase_demo();

	wp_send_json_success();
}

function themify_clear_all_webp(){
	check_ajax_referer('ajax-nonce', 'nonce');
	wp_send_json_success(Themify_Enqueue_Assets::removeWebp());
}

function themify_clear_all_concate(){
	check_ajax_referer('ajax-nonce', 'nonce');
        $type=false;
        if(is_multisite()){
		$data = themify_normalize_save_data($_POST['data']);
		if(!empty($data['tmp_cache_concte_network'])){
                    $type='all';
		}
		$data=null;
	}
	Themify_Enqueue_Assets::clearConcateCss($type);
	die('1');
}

function themify_clear_all_menu(){
	check_ajax_referer('ajax-nonce', 'nonce');
	TFCache::remove_cache();
        TFCache::clear_3rd_plugins_cache();
	themify_clear_menu_cache();
	die('1');
}

function themify_clear_all_html(){
    check_ajax_referer('ajax-nonce', 'nonce');
	$type='blog';
	if(is_multisite()){
		$data = themify_normalize_save_data($_POST['data']);
		if(!empty($data['tmp_cache_network'])){
			$type='all';
		}
		$data=null;
	}
    TFCache::remove_cache($type);
    die('1');
}
add_action('wp_ajax_nopriv_themify_search_autocomplete','themify_search_autocomplete');
function themify_search_autocomplete(){
    if(!empty($_POST['s'])){
        $s  = sanitize_text_field($_POST['s']);
        if(!empty($s)){
            global $query,$found_types;
            if(!empty($_POST['post_type'])){
                $post_types  = array(sanitize_text_field($_POST['post_type']));
            }else{
                if(true===themify_is_woocommerce_active() && 'product' === themify_get( 'setting-search_post_type','all',true )){
                    $post_types = array('product');
                }else{
                    $post_types = Themify_Builder_Model::get_post_types();
                    unset($post_types['attachment']);
                    $post_types=array_keys($post_types);
                }
            }
            $query_args = array(
                'post_type'=>$post_types,
                'post_status'=>'publish',
                'posts_per_page'=>22,
                's'=>$s
            );
            if(!empty($_POST['term'])){
                Themify_Builder_Model::parseTermsQuery( $query_args, urldecode($_POST['term']), $_POST['tax'] );
            }
            $query_args = apply_filters('themify_search_args',$query_args);
            wp_reset_postdata();
            $query = new WP_Query( $query_args );
            $found_types=array();
            while ( $query->have_posts() ){
                $query->the_post();
                $post_type = get_post_type();
                if (($key = array_search($post_type, $query_args['post_type'])) !== false) {
                    unset($query_args['post_type'][$key]);
                    $found_types[]=$post_type;
                }
                if(empty($query_args['post_type'])){
                    break;
                }
            }
            $query->rewind_posts();

            ob_start();
            include( THEMIFY_DIR.'/includes/search-box-result.php' );
            ob_end_flush();
        }
    }
    wp_die();
}

function themify_twitter_flush() {
	check_ajax_referer( 'ajax-nonce', 'nonce' );
	Themify_Twitter_Api::clear_cache();
	die('1');
}

/*Load More Ajax - Used for module ajax load more*/
if(!function_exists('themify_ajax_load_more')){
    function themify_ajax_load_more(){
        if(!empty($_POST['module']) && !empty($_POST['id'])){
            $builder_id=(int)($_POST['id']);
            $el_id=sanitize_text_field($_POST['module']);
            $mod_id=str_replace('tb_','',$el_id);
            global $ThemifyBuilder;
            $data = $ThemifyBuilder->get_flat_modules_list( (int)$_POST['id'] );
            if ( ! empty( $data ) ) {
                foreach ( $data as $module ) {
                    if ( isset( $module['element_id'], $module['mod_settings'] ) && $module['element_id'] === $mod_id ) {
                        $mod_setting = $module['mod_settings'];
                        $slug = $module['mod_name'];
                    }
                }
            }
            if(!empty($mod_setting)){
                global $paged;
                $paged=(int)$_POST['page'];
                $paged=$paged<1?1:$paged;
                if(themify_is_themify_theme() && is_file(THEME_DIR.'/theme-options.php')){
                    require_once( THEME_DIR.'/theme-options.php' );
                    global $themify;
                    if(isset($themify) && method_exists($themify,'template_redirect')){
                        $themify->template_redirect();
                    }
                }
                echo Themify_Builder_Model::$modules[ $slug ]->render($slug, $el_id, $builder_id, $mod_setting);
            }
        }
        wp_die();
    }
    // Ajax filter actions
    add_action('wp_ajax_nopriv_themify_ajax_load_more','themify_ajax_load_more');
}